/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.ucode;

import com.ibm.hsc.auiml.databeans.ucode.AutoSurveyResults;
import com.ibm.hsc.auiml.databeans.ucode.ChangeRepos;
import com.ibm.hsc.auiml.databeans.ucode.GroupInformation;
import com.ibm.hsc.auiml.databeans.ucode.GroupItem;
import com.ibm.hsc.auiml.databeans.ucode.InfoPanel;
import com.ibm.hsc.auiml.databeans.ucode.LicensePanel;
import com.ibm.hsc.auiml.databeans.ucode.OverviewSurveyBeanExt;
import com.ibm.hsc.auiml.databeans.ucode.RepositoryItem;
import com.ibm.hsc.auiml.databeans.ucode.ResourceItem;
import com.ibm.hsc.auiml.databeans.ucode.SurveyFileResult;
import com.ibm.hsc.auiml.databeans.ucode.UcodeLauncherUtil;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.websm.launch.ucode.UcodeSurveyException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.TaskSelectionEvent;
import com.ibm.ui.framework.UserTaskManager;
import java.util.ArrayList;

public class OverviewSurveyBeanMenuHandler
implements TaskActionListener {
    private static final short ERRID_0021 = 33;
    private static final String TRACE_MASKD = "JUCODECD";
    private static final String TRACE_MASKF = "JUCODECF";
    private static final String TRACE_MASKT = "JUCODECT";
    public static final String RESOURCE_TABLE = "OverviewTable";
    public static final String CD_TOP_DIR = "/microcode/";
    String[] selectedName;
    String[] selectedMTMS;
    String[] selectedType;
    OverviewSurveyBeanExt bean;
    UserTaskManager utm;
    ChangeRepos reposBean;
    RepositoryItem currentRepos;

    public void actionPerformed(TaskActionEvent taskActionEvent) {
        Trace.trace(TRACE_MASKT, "-> OverviewSurveyBeanMenuHandler.actionPerformed() " + taskActionEvent);
        String string = taskActionEvent.getElementName();
        Trace.trace(TRACE_MASKD, "OverviewSurveyBeanMenuHandler.actionPerformed() item selected is " + string);
        try {
            Object object;
            this.utm = (UserTaskManager)taskActionEvent.getSource();
            this.bean = (OverviewSurveyBeanExt)this.utm.getDataObjects()[0];
            this.currentRepos = this.bean.getRepos();
            this.utm.storeAllElements();
            if (string.equals("SurveyButton")) {
                ItemDescriptor[] itemDescriptorArray;
                Trace.trace(TRACE_MASKF, "OverviewSurveyBeanMenuHandler SurveyButton selected... ");
                object = this.bean.getGroupList();
                GroupItem groupItem = new GroupItem("Internal", "SEL-000", "SelectedGroup");
                ((GroupInformation)object).addGroup(groupItem);
                Trace.trace(TRACE_MASKD, "starting to build resources...");
                int[] nArray = this.utm.getSelectedRows(RESOURCE_TABLE);
                if (nArray == null) {
                    Trace.trace(TRACE_MASKD, "No row selected in resource Table");
                    Trace.trace(TRACE_MASKT, "<- OverviewSurveyBeanMenuHandler.actionPerformed() ");
                    InfoPanel infoPanel = new InfoPanel("0014", HSCResourceBundleUtil.getMessage("UcodeBundleMessages", "0014", "Error: No row selected in resource Table"));
                    UcodeLauncherUtil.launchInformationMessage(this.utm, infoPanel);
                    return;
                }
                Trace.trace(TRACE_MASKD, "Number of rows in table is: " + nArray.length);
                if (nArray.length == 0) {
                    Trace.trace(TRACE_MASKD, "No rows in table to process.");
                    InfoPanel infoPanel = new InfoPanel("0014", HSCResourceBundleUtil.getMessage("UcodeBundleMessages", "0014", "Error: No row selected in resource Table"));
                    UcodeLauncherUtil.launchInformationMessage(this.utm, infoPanel);
                    return;
                }
                String string2 = null;
                String string3 = null;
                String string4 = null;
                ResourceItem resourceItem = null;
                int n = 0;
                while (n < nArray.length) {
                    Object object2;
                    Trace.trace(TRACE_MASKD, "index: " + n + " for table row " + nArray[n]);
                    int n2 = nArray[n];
                    itemDescriptorArray = this.utm.getRow(RESOURCE_TABLE, n2);
                    Trace.trace(TRACE_MASKD, "Retrieving row " + n2 + " from " + RESOURCE_TABLE);
                    string4 = itemDescriptorArray[0].getTitle();
                    Trace.trace(TRACE_MASKD, "Table row " + nArray[n] + " type is " + string4);
                    string3 = itemDescriptorArray[1].getTitle();
                    Trace.trace(TRACE_MASKD, "Table row " + nArray[n] + " MTMS is " + string3);
                    string2 = itemDescriptorArray[2].getTitle();
                    Trace.trace(TRACE_MASKD, "Table row " + nArray[n] + " name is " + string2);
                    if (string4.equals(ResourceItem.resource_cec)) {
                        resourceItem = new ResourceItem(string4, 4, string3, string2, " ", " ", " ", " ", "", "", "", "", " ", " ", " ", " ", " ", " ", " ", " ");
                    } else if (string4.equals(ResourceItem.resource_switch_network)) {
                        resourceItem = new ResourceItem(string4, 5, string3, string2, " ", " ", " ", " ", "", "", "", "", " ", " ", " ", " ", " ", " ", " ", " ");
                    } else if (string4.equals(ResourceItem.resource_bpa)) {
                        resourceItem = new ResourceItem(string4, 6, string3, string2, " ", " ", " ", " ", "", "", "", "", " ", " ", " ", " ", " ", " ", " ", " ");
                    } else {
                        object2 = new Object[]{string4 + " not found"};
                        InfoPanel infoPanel = new InfoPanel("0013", HSCResourceBundleUtil.getMessage("UcodeBundleMessages", "0013", "Error loading resource: " + object2[0], object2));
                        UcodeLauncherUtil.launchInformationMessage(this.utm, infoPanel);
                        return;
                    }
                    Trace.trace(TRACE_MASKD, "created Resource for: " + resourceItem.getFullName());
                    groupItem.addResource(resourceItem);
                    object2 = new GroupItem(string4, string3, string2);
                    ((GroupInformation)object).addGroup((GroupItem)object2);
                    ++n;
                }
                itemDescriptorArray = this.bean.getProperty("licenseaccept");
                boolean bl = false;
                Trace.trace(TRACE_MASKF, "license property is " + bl);
                if (itemDescriptorArray.trim().equals("false")) {
                    try {
                        this.downloadLicenseFile(this.bean);
                    }
                    catch (Exception exception) {
                        Trace.trace(TRACE_MASKD, "caught Exception from downloadLicenseFile: " + exception.toString());
                        Trace.trace(TRACE_MASKT, "<- OverviewSurveyBeanMenuHandler.actionPerformed() ");
                        return;
                    }
                    try {
                        this.bean.setLicenseAnswer(false);
                        this.displayLicenseFile(this.bean);
                    }
                    catch (Exception exception) {
                        Trace.trace(TRACE_MASKD, "caught Exception from launchLicenseFile: " + exception.toString());
                        Trace.trace(TRACE_MASKT, "<- OverviewSurveyBeanMenuHandler.actionPerformed() ");
                        return;
                    }
                    if (this.bean.getLicenseAnswer()) {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    try {
                        this.downloadCatalogFile(this.bean);
                    }
                    catch (Exception exception) {
                        Trace.trace(TRACE_MASKD, "caught Exception from downloadCatalogFile: " + exception.toString());
                        Trace.trace(TRACE_MASKT, "<- OverviewSurveyBeanMenuHandler.actionPerformed() ");
                        return;
                    }
                    AutoSurveyResults autoSurveyResults = new AutoSurveyResults(this.bean.getRepos(), this.bean);
                    UcodeLauncherUtil.launchSurveyResults(this.utm, autoSurveyResults, this.bean.getRepos());
                }
            }
            if (string.equals("ChangeButton")) {
                this.reposBean = new ChangeRepos();
                this.reposBean.saveCallingBean(this.bean);
                Trace.trace(TRACE_MASKD, "Calling UcodeLauncherUtil ");
                UcodeLauncherUtil.launchSelectRepos(this.utm, this.reposBean, this.bean.getRepos());
            }
            if (string.equals("SelectAll")) {
                Trace.trace(TRACE_MASKD, "OverviewSurveyBeanMenuHandler SelectAll selected... ");
                this.selectAllInputRows(true);
            }
            if (string.equals("DeselectAll")) {
                Trace.trace(TRACE_MASKD, "OverviewSurveyBeanMenuHandler DeselectAll selected... ");
                this.selectAllInputRows(false);
            }
            object = this.utm.getSelectedRows(RESOURCE_TABLE);
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKD, "caught ThrowableException: " + exception.toString());
        }
        this.utm.storeAllElements();
        Trace.trace(TRACE_MASKT, "<- OverviewSurveyBeanMenuHandler.actionPerformed() ");
    }

    public void downloadCatalogFile(OverviewSurveyBeanExt overviewSurveyBeanExt) throws UcodeSurveyException {
        Object object;
        Object[] objectArray;
        Trace.trace(TRACE_MASKT, "-> downloadCatalogFile () ");
        int n = -1;
        String string = this.currentRepos.getLocation();
        Trace.trace(TRACE_MASKD, "input Repository is " + string);
        if (this.currentRepos.getReposType() == 0 || this.currentRepos.getReposType() == 4) {
            Trace.trace(TRACE_MASKD, "entering download from FTP site code...");
            try {
                objectArray = this.bean.getProperty("catalogname");
                if (this.currentRepos.getReposType() == 0) {
                    overviewSurveyBeanExt.getFileFromHTTPSite((String)objectArray);
                    Trace.trace(TRACE_MASKF, "download from IBM Service site completed");
                } else {
                    String string2 = this.currentRepos.getLocation();
                    object = this.currentRepos.getFTPUSER();
                    String string3 = this.currentRepos.getFTPPW();
                    overviewSurveyBeanExt.getFileFromFTPSite(string2, (String)objectArray, (String)object, string3);
                    Trace.trace(TRACE_MASKF, "download from FTP site " + string2 + " completed");
                }
            }
            catch (UcodeSurveyException ucodeSurveyException) {
                Trace.trace(TRACE_MASKF, "Exception caught doing remote file transfer " + ucodeSurveyException);
                Object[] objectArray2 = ucodeSurveyException.getArgs();
                InfoPanel infoPanel = new InfoPanel(ucodeSurveyException.getKey(), HSCResourceBundleUtil.getMessage("UcodeBundleMessages", ucodeSurveyException.getKey(), "An error occurred getting catalog file from " + ucodeSurveyException, objectArray2));
                UcodeLauncherUtil.launchInformationMessage(this.utm, infoPanel);
                Trace.trace(TRACE_MASKT, "<- downloadCatalogFile()");
                throw ucodeSurveyException;
            }
        }
        if (this.currentRepos.getReposType() == 1) {
            Trace.trace(TRACE_MASKD, "entering download from Media code...");
            try {
                overviewSurveyBeanExt.getFileFromCD(CD_TOP_DIR + this.bean.getProperty("catalogname"), this.utm);
                Trace.trace(TRACE_MASKF, "download of Catalog file from CDROM completed");
            }
            catch (UcodeSurveyException ucodeSurveyException) {
                Trace.trace(TRACE_MASKF, "Exception caught doing file transfer from CDROM: " + ucodeSurveyException);
                objectArray = ucodeSurveyException.getArgs();
                object = new InfoPanel(ucodeSurveyException.getKey(), HSCResourceBundleUtil.getMessage("UcodeBundleMessages", ucodeSurveyException.getKey(), "ERROR occurred getting catalog file from CDROM \n\n" + ucodeSurveyException, objectArray));
                UcodeLauncherUtil.launchInformationMessage(this.utm, (InfoPanel)object);
                throw ucodeSurveyException;
            }
            Trace.trace(TRACE_MASKT, "<- downloadCatalogFile()");
            return;
        }
    }

    public void downloadLicenseFile(OverviewSurveyBeanExt overviewSurveyBeanExt) throws UcodeSurveyException {
        Trace.trace(TRACE_MASKT, "-> downloadLicenseFile () ");
        int n = -1;
        String string = this.currentRepos.getLocation();
        Trace.trace(TRACE_MASKD, "input Repository is " + string);
        if (this.currentRepos.getReposType() == 0 || this.currentRepos.getReposType() == 4) {
            Trace.trace(TRACE_MASKD, "entering download from FTP site code...");
            try {
                String string2 = this.bean.getProperty("licensename");
                if (this.currentRepos.getReposType() == 0) {
                    overviewSurveyBeanExt.getFileFromHTTPSite(string2);
                    Trace.trace(TRACE_MASKF, "download from IBM Service site completed");
                } else {
                    String string3 = this.currentRepos.getLocation();
                    String string4 = this.currentRepos.getFTPUSER();
                    String string5 = this.currentRepos.getFTPPW();
                    overviewSurveyBeanExt.getFileFromFTPSite(string3, string2, string4, string5);
                    Trace.trace(TRACE_MASKF, "download from FTP site " + string3 + " completed");
                }
            }
            catch (UcodeSurveyException ucodeSurveyException) {
                Trace.trace(TRACE_MASKF, "Exception caught doing remote file transfer " + ucodeSurveyException);
                Object[] objectArray = ucodeSurveyException.getArgs();
                InfoPanel infoPanel = new InfoPanel(ucodeSurveyException.getKey(), HSCResourceBundleUtil.getMessage("UcodeBundleMessages", ucodeSurveyException.getKey(), "An error occurred getting license file from " + ucodeSurveyException, objectArray));
                UcodeLauncherUtil.launchInformationMessage(this.utm, infoPanel);
                Trace.trace(TRACE_MASKT, "<- downloadLicenseFile()");
                throw ucodeSurveyException;
            }
            Trace.trace(TRACE_MASKT, "<- downloadLicenseFile()");
            return;
        }
        if (this.currentRepos.getReposType() == 1) {
            Trace.trace(TRACE_MASKD, "entering download from Media code...");
            try {
                overviewSurveyBeanExt.getFileFromCD(CD_TOP_DIR + this.bean.getProperty("licensename"), this.utm);
            }
            catch (UcodeSurveyException ucodeSurveyException) {
                Trace.trace(TRACE_MASKD, "caught Exception from getting from CDROM: " + ucodeSurveyException.toString());
                Object[] objectArray = ucodeSurveyException.getArgs();
                InfoPanel infoPanel = new InfoPanel(ucodeSurveyException.getKey(), HSCResourceBundleUtil.getMessage("UcodeBundleMessages", ucodeSurveyException.getKey(), "An error occurred getting license file from CDROM " + ucodeSurveyException, objectArray));
                UcodeLauncherUtil.launchInformationMessage(this.utm, infoPanel);
            }
            Trace.trace(TRACE_MASKT, "<- downloadLicenseFile()");
            return;
        }
    }

    public void displayLicenseFile(OverviewSurveyBeanExt overviewSurveyBeanExt) {
        Trace.trace(TRACE_MASKT, "-> OverviewSurveyBeanMenuHandler.displayLicenseFile()");
        boolean bl = false;
        String string = "";
        try {
            SurveyFileResult surveyFileResult = overviewSurveyBeanExt.getLicenseFile();
            if (surveyFileResult == null) {
                Trace.trace(TRACE_MASKF, "License File is null!");
                InfoPanel infoPanel = new InfoPanel("0043", HSCResourceBundleUtil.getMessage("UcodeBundleMessages", "0043", "AN error occurred reading license file, file was null.  The file was either not found or was empty."));
                UcodeLauncherUtil.launchInformationMessage(this.utm, infoPanel);
            }
            int n = 0;
            while (n < surveyFileResult.size()) {
                string = string + surveyFileResult.getRecord(n) + "\n";
                ++n;
            }
            Trace.trace(TRACE_MASKD, "number of records read was " + surveyFileResult.size());
            LicensePanel licensePanel = new LicensePanel(string);
            UcodeLauncherUtil.launchLicenseMessage(this.utm, licensePanel);
        }
        catch (UcodeSurveyException ucodeSurveyException) {
            Trace.trace(TRACE_MASKF, "caught Exception from reading license file: " + ucodeSurveyException.toString());
            Object[] objectArray = ucodeSurveyException.getArgs();
            InfoPanel infoPanel = new InfoPanel(ucodeSurveyException.getKey(), HSCResourceBundleUtil.getMessage("UcodeBundleMessages", ucodeSurveyException.getKey(), "Error occurred reading license file: " + ucodeSurveyException.toString(), objectArray));
            UcodeLauncherUtil.launchInformationMessage(this.utm, infoPanel);
        }
        Trace.trace(TRACE_MASKD, "retrieving license file complete");
        Trace.trace(TRACE_MASKT, "<- OverviewSurveyBeanMenuHandler.displayLicenseFile()");
    }

    public void selectAllInputRows(boolean bl) {
        Trace.trace(TRACE_MASKT, "-> OverviewSurveyBeanMenuHandler.selectAllRows()");
        ArrayList arrayList = this.bean.getResourceList();
        if (bl) {
            int[] nArray = new int[arrayList.size()];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = n;
                ++n;
            }
            this.utm.setSelectedRows(RESOURCE_TABLE, nArray);
        } else {
            this.utm.setSelectedRows(RESOURCE_TABLE, null);
        }
        Trace.trace(TRACE_MASKT, "<- OverviewSurveyBeanMenuHandler.selectAllRows()");
    }

    public void selectionChanged(TaskSelectionEvent taskSelectionEvent) {
        Trace.trace(TRACE_MASKT, "-> OverviewSurveyBeanMenuHandler.selectionChanged() " + taskSelectionEvent);
        UserTaskManager userTaskManager = (UserTaskManager)taskSelectionEvent.getSource();
        String string = taskSelectionEvent.getElementName();
        Trace.trace(TRACE_MASKD, "Table item " + string + " selected.");
        Trace.trace(TRACE_MASKT, "<- OverviewSurveyBeanMenuHandler.selectionChanged() ");
    }
}

